﻿using System;
using System.Collections.Generic;
using System.Text;
using System.ComponentModel;

namespace IndianHealthService.BMXNet.Model
{
    /// <summary>
    /// The argument to the ContextChanged method.  This event has methods that allow you
    /// to detect which aspects of the context have changed and what the new context is.
    /// </summary>
    public class ContextChangedArgs:EventArgs
    {
        private bool _isVisitChange = false;
                
        /// <summary>
        /// Answer if the visit had changed.  When the patient changes and a visit had been selected, the
        /// visit will change to null.
        /// </summary>
        /// <example>
        /// In the following example, the first tab of a notebook is selected whenever the patient changes.
        /// <code>
        /// void Context_Changed(object sender, ContextChangedArgs e)
        /// {
        ///     if (e.IsPatientChange)
        ///     {
        ///         this.SelectedIndex = 1;
        ///         this.RefreshAll();
        ///     }
        /// }
        /// </code>
        /// </example>
        public bool IsVisitChange
        {
            get { return _isVisitChange; }
            set { _isVisitChange = value; }
        }
        private bool _isPatientChange = false;

        /// <summary>
        /// Answer if the patient had changed.
        /// </summary>
        public bool IsPatientChange
        {
            get { return _isPatientChange; }
            set { _isPatientChange = value; }
        }


        private Context _afterContext = null;

        /// <summary>
        /// The current state of the context.  This context object is that same instance used for the 
        /// life of the LocalSession
        /// </summary>
        public Context AfterContext
        {
            get { return _afterContext; }
            set { _afterContext = value; }
        }
    }
}
